package com.bitbof.escape.entities;

import org.lwjgl.examples.spaceinvaders.Texture;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

import com.bitbof.escape.Art;

public class ElasticSegment implements Entity{
	
	public Vector2f pos, pos2;
	public boolean alive = true;
	public long age = 0;
	public ElasticSegment(Vector2f start, Vector2f end) {
		pos = new Vector2f(start);
		pos2 = new Vector2f(end);
	}
	
	
	@Override
	public void tick() {
		age++;
		if(age > 1000) {
			alive = false;
		}
	}

	@Override
	public void render() {
		if(!alive)
			return;
		Texture texture = Art.band;
		texture.bind();
		GL11.glPushMatrix();
		GL11.glColor4f(1, 1, 1, 0.5f);
		GL11.glTranslatef(pos.x, pos.y, 0);
		
		Vector2f rel = new Vector2f(pos2.x-pos.x, pos2.y-pos.y);
		
		double angle = Vector2f.angle(rel, new Vector2f(1,0))/Math.PI*180;
		if(rel.y < 0)
			angle *= -1;
		GL11.glRotatef((float) angle, 0, 0, 1);//);
		
		GL11.glTranslatef((new Vector2f(pos2.x-pos.x, pos2.y-pos.y).length())*0.5f, 0, 0);
		GL11.glScalef(new Vector2f(pos2.x-pos.x, pos2.y-pos.y).length(), 20*0.5f, 0);
		GL11.glBegin(GL11.GL_QUADS);
		GL11.glTexCoord2f(0, 0);
		GL11.glVertex2f(-0.5f, -0.5f);
		GL11.glTexCoord2f(0, texture.getHeight());
		GL11.glVertex2f(0.5f, -0.5f);
		GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
		GL11.glVertex2f(0.5f, 0.5f);
		GL11.glTexCoord2f(texture.getWidth(), 0);
		GL11.glVertex2f(-0.5f, 0.5f);
		GL11.glEnd();

		GL11.glPopMatrix();
	}

	@Override
	public boolean isAlive() {
		return alive;
	}

}
